CREATE TABLE IF NOT EXISTS `#__timetable_columns` (
	`id` integer(10) UNSIGNED NOT NULL auto_increment,
	`title`  varchar(100) NOT NULL DEFAULT '',
	`alias` varchar(100) NOT NULL UNIQUE default '',
	`published` tinyint(1) NOT NULL default '0',  
	`ordering` integer NOT NULL default '0',
	`params` text NOT NULL,
	`created` datetime NOT NULL default '0000-00-00 00:00:00',
	`created_by` int(10) unsigned NOT NULL default '0',
	`created_by_alias` varchar(255) NOT NULL default '',
	`modified` datetime NOT NULL default '0000-00-00 00:00:00',
	`modified_by` int(10) unsigned NOT NULL default '0',
	`metakey` text NOT NULL,
	`metadesc` text NOT NULL,
	`metadata` text NOT NULL,
	`publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
	`publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
	PRIMARY KEY  (`id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `#__timetable_categories` (
	`id` integer(10) UNSIGNED NOT NULL auto_increment,
	`title`  varchar(100) NOT NULL DEFAULT '',
	`alias` varchar(100) NOT NULL UNIQUE default '',
	`published` tinyint(1) NOT NULL default '0',  
	`ordering` integer NOT NULL default '0',
	`params` text NOT NULL,
	`created` datetime NOT NULL default '0000-00-00 00:00:00',
	`created_by` int(10) unsigned NOT NULL default '0',
	`created_by_alias` varchar(255) NOT NULL default '',
	`modified` datetime NOT NULL default '0000-00-00 00:00:00',
	`modified_by` int(10) unsigned NOT NULL default '0',
	`metakey` text NOT NULL,
	`metadesc` text NOT NULL,
	`metadata` text NOT NULL,
	`publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
	`publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
	PRIMARY KEY  (`id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__timetable_events` (
	`id` integer(10) UNSIGNED NOT NULL auto_increment,
	`title`  varchar(100) NOT NULL DEFAULT '',
	`alias` varchar(100) NOT NULL UNIQUE default '',  
	`content` TEXT NOT NULL,
	`published` tinyint(1) NOT NULL default '0',  
	`ordering` integer NOT NULL default '0',
	`params` text NOT NULL,
	`created` datetime NOT NULL default '0000-00-00 00:00:00',
	`created_by` int(10) unsigned NOT NULL default '0',
	`created_by_alias` varchar(255) NOT NULL default '',
	`modified` datetime NOT NULL default '0000-00-00 00:00:00',
	`modified_by` int(10) unsigned NOT NULL default '0',
	`metakey` text NOT NULL,
	`metadesc` text NOT NULL,
	`metadata` text NOT NULL,
	`publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
	`publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
	PRIMARY KEY  (`id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__timetable_event_options` (
	`option_id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`event_id` INT(11) NOT NULL,
	`option_key` VARCHAR(255) NOT NULL,
	`option_value` LONGTEXT NOT NULL,
	PRIMARY KEY (`option_id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__timetable_event_categories` (
	`id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
	`event_id` INT(11) NOT NULL,
	`category_id` INT(11) NOT NULL,
	PRIMARY KEY (`id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;
	
CREATE TABLE IF NOT EXISTS `#__timetable_event_hours` (
  `id` INT(11) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` INT(11) NOT NULL,
  `weekday_id` INT(11) NOT NULL,
  `start` time NOT NULL,
  `end` time NOT NULL,
  `tooltip` text COLLATE utf8_unicode_ci NOT NULL,
  `before_hour_text` text COLLATE utf8_unicode_ci NOT NULL,
  `after_hour_text` text COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE = MYISAM DEFAULT CHARSET=utf8;
